/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt.lib;

import cc.tweaked.cobalt.internal.doubles.DoubleToStringConverter;
import java.math.BigDecimal;
import org.squiddev.cobalt.Buffer;
import org.squiddev.cobalt.ErrorFactory;
import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.LuaInteger;
import org.squiddev.cobalt.LuaState;
import org.squiddev.cobalt.LuaString;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.OperationHelper;
import org.squiddev.cobalt.UnwindThrowable;
import org.squiddev.cobalt.Varargs;
import org.squiddev.cobalt.lib.FormatDesc;

class StringFormat {
    private static final BigDecimal U64_MAX = BigDecimal.valueOf(2L).pow(64);

    StringFormat() {
    }

    static LuaString format(LuaState state, FormatState format) throws LuaError, UnwindThrowable {
        LuaString fmt = format.format;
        int n = fmt.length();
        Buffer result = format.buffer;
        int i = format.i;
        block11: while (i < n) {
            int c;
            if ((c = fmt.charAt(i++)) != 37) {
                result.append((byte)c);
                continue;
            }
            if (i >= n) {
                throw new LuaError("invalid conversion '%' to 'format'");
            }
            if (fmt.charAt(i) == 37) {
                ++i;
                result.append((byte)37);
                continue;
            }
            int argIndex = ++format.arg;
            LuaValue value = format.args.arg(argIndex);
            FormatDesc desc = new FormatDesc(fmt, i);
            i += desc.length;
            switch (desc.conversion) {
                case 99: {
                    desc.checkFlags(1);
                    desc.format(result, (byte)value.checkLong());
                    continue block11;
                }
                case 100: 
                case 105: {
                    desc.checkFlags(55);
                    desc.format(result, StringFormat.toSignedLong(argIndex, value));
                    continue block11;
                }
                case 117: {
                    desc.checkFlags(49);
                    desc.format(result, StringFormat.toUnsignedLong(argIndex, value));
                    continue block11;
                }
                case 88: 
                case 111: 
                case 120: {
                    desc.checkFlags(57);
                    desc.format(result, StringFormat.toUnsignedLong(argIndex, value));
                    continue block11;
                }
                case 65: 
                case 69: 
                case 71: 
                case 97: 
                case 101: 
                case 102: 
                case 103: {
                    desc.checkFlags(63);
                    desc.format(result, value.checkDouble());
                    continue block11;
                }
                case 113: {
                    if (desc.length != 1) {
                        throw new LuaError("specifier '%q' cannot have modifiers");
                    }
                    StringFormat.addQuoted(result, format.arg, value);
                    continue block11;
                }
                case 115: {
                    desc.checkFlags(33);
                    try {
                        desc.format(result, OperationHelper.checkToString(OperationHelper.toString(state, value)));
                        continue block11;
                    }
                    catch (UnwindThrowable e) {
                        format.current = desc;
                        format.i = i;
                        throw e;
                    }
                }
            }
            Buffer buffer = new Buffer();
            buffer.append("invalid conversion '%");
            buffer.append(desc.format, desc.start, desc.length);
            buffer.append("' to 'format'");
            throw new LuaError(buffer.toLuaString());
        }
        return result.toLuaString();
    }

    private static long toSignedLong(int arg, LuaValue value) throws LuaError {
        long asLong;
        if (value instanceof LuaInteger) {
            LuaInteger i = (LuaInteger)value;
            return i.checkLong();
        }
        double asDouble = value.checkDouble();
        double difference = asDouble - (double)(asLong = (long)asDouble);
        if (-1.0 < difference && difference < 1.0) {
            return asLong;
        }
        throw ErrorFactory.argError(arg, "not a number in proper range");
    }

    private static long toUnsignedLong(int arg, LuaValue value) throws LuaError {
        if (value instanceof LuaInteger) {
            LuaInteger i = (LuaInteger)value;
            return i.checkLong();
        }
        double asDouble = value.checkDouble();
        if (asDouble < 9.223372036854776E18) {
            long asLong = (long)asDouble;
            double difference = asDouble - (double)asLong;
            if (-1.0 < difference && difference < 1.0) {
                return asLong;
            }
        } else {
            BigDecimal asBigDecimal = new BigDecimal(asDouble);
            if (asBigDecimal.compareTo(U64_MAX) <= 0) {
                return asBigDecimal.longValue();
            }
        }
        throw ErrorFactory.argError(arg, "not a number in proper range");
    }

    private static void addQuoted(Buffer buf, int arg, LuaValue s) throws LuaError {
        switch (s.type()) {
            case 4: {
                StringFormat.addQuoted(buf, s.checkLuaString());
                break;
            }
            case 3: {
                if (s instanceof LuaInteger) {
                    buf.append(Integer.toString(s.checkInteger()));
                    break;
                }
                double value = s.checkDouble();
                if (Double.isNaN(value)) {
                    buf.append("(0/0)");
                    break;
                }
                if (value == Double.POSITIVE_INFINITY) {
                    buf.append("1e9999");
                    break;
                }
                if (value == Double.NEGATIVE_INFINITY) {
                    buf.append("-1e9999");
                    break;
                }
                if ((double)((long)value) == value) {
                    buf.append(Long.toString((long)value));
                    break;
                }
                DoubleToStringConverter.toHex(value, -1, FormatDesc.DEFAULT_LOWER_OPTIONS, buf);
                break;
            }
            case 0: 
            case 1: {
                buf.append(s.toString());
                break;
            }
            default: {
                throw ErrorFactory.argError(arg, "value has no literal form");
            }
        }
    }

    private static void addQuoted(Buffer buf, LuaString s) {
        buf.append((byte)34);
        int n = s.length();
        block5: for (int i = 0; i < n; ++i) {
            int c = s.charAt(i);
            switch (c) {
                case 10: 
                case 34: 
                case 92: {
                    buf.append((byte)92);
                    buf.append((byte)c);
                    continue block5;
                }
                case 13: {
                    buf.append("\\r");
                    continue block5;
                }
                case 0: {
                    buf.append("\\000");
                    continue block5;
                }
                default: {
                    buf.append((byte)c);
                }
            }
        }
        buf.append((byte)34);
    }

    static class FormatState {
        final LuaString format;
        int i = 0;
        final Buffer buffer;
        int arg = 1;
        final Varargs args;
        FormatDesc current;

        FormatState(LuaString format, Buffer buffer, Varargs args) {
            this.args = args;
            this.format = format;
            this.buffer = buffer;
        }
    }
}

